/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class CachedFailedInsertInventoryHandler
implements SlottedStackStorage {
    private final Supplier<SlottedStackStorage> wrappedHandlerGetter;
    private final LongSupplier timeSupplier;
    private long currentCacheTime = 0L;
    private final Set<Integer> failedInsertStackHashes = new HashSet<Integer>();

    public CachedFailedInsertInventoryHandler(Supplier<SlottedStackStorage> wrappedHandlerGetter, LongSupplier timeSupplier) {
        this.wrappedHandlerGetter = wrappedHandlerGetter;
        this.timeSupplier = timeSupplier;
    }

    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.wrappedHandlerGetter.get().setStackInSlot(slot, stack);
    }

    public int getSlotCount() {
        return this.wrappedHandlerGetter.get().getSlotCount();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.wrappedHandlerGetter.get().getSlot(slot);
    }

    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.wrappedHandlerGetter.get().getStackInSlot(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStackHashes.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        if (this.failedInsertStackHashes.contains(resource.hashCode())) {
            return 0L;
        }
        long inserted = this.wrappedHandlerGetter.get().insert((Object)resource, maxAmount, ctx);
        if (inserted == 0L) {
            this.failedInsertStackHashes.add(resource.hashCode());
        }
        return inserted;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStackHashes.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        if (this.failedInsertStackHashes.contains(resource.hashCode())) {
            return 0L;
        }
        long inserted = this.wrappedHandlerGetter.get().insertSlot(slot, resource, maxAmount, ctx);
        if (inserted == 0L) {
            this.failedInsertStackHashes.add(resource.hashCode());
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.wrappedHandlerGetter.get().extract((Object)resource, maxAmount, ctx);
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.wrappedHandlerGetter.get().extractSlot(slot, resource, maxAmount, ctx);
    }

    public int getSlotLimit(int slot) {
        return this.wrappedHandlerGetter.get().getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemVariant resource, int count) {
        return this.wrappedHandlerGetter.get().isItemValid(slot, resource, count);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return this.wrappedHandlerGetter.get().iterator();
    }
}

